using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace PDFCreatorApp
{
	/// <summary>
	/// Summary description for AttributesForm.
	/// </summary>
	public class AttributesForm : System.Windows.Forms.Form
	{
		public System.Windows.Forms.ListView listViewAttrib;
		private System.Windows.Forms.ColumnHeader columnHeaderName;
		private System.Windows.Forms.ColumnHeader columnHeaderValue;
		public System.Windows.Forms.Label lblAttrib;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.ColumnHeader columnHeaderType;
		private System.Windows.Forms.ColumnHeader columnHeaderValues;
		private System.Windows.Forms.ColumnHeader columnHeaderHelp;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ListView listViewProperties;
		public System.Windows.Forms.ColumnHeader columnHeaderModified;
		public System.Windows.Forms.ColumnHeader columnHeaderSelected;
		private System.Windows.Forms.ColumnHeader columnHeaderAnnotation;
		private System.Windows.Forms.ColumnHeader columnHeaderPage;
		private System.Windows.Forms.ColumnHeader columnHeaderCoordinates;
		private System.Windows.Forms.Label label2;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public AttributesForm(Amyuni.PDFCreator.IacObject acObject)
		{
			//
			// Required for Windows Form Designer support
			//

			InitializeComponent();

			int attribCount = acObject.AttributeCount;
			lblAttrib.Text = string.Format("Object: {0}  \n\n", acObject.Name);

			// set properties
			ListViewItem propItem = this.listViewProperties.Items.Add(acObject.Modified.ToString());
			propItem.SubItems.Add(acObject.Selected.ToString());
			propItem.SubItems.Add(acObject.Annotation.ToString());
			if (acObject.GetPage() != null)
				propItem.SubItems.Add(acObject.GetPage().PageNumber.ToString());
			else
				propItem.SubItems.Add("");

			System.Drawing.Rectangle rect = new System .Drawing .Rectangle();
			rect = acObject.Coordinates;
			propItem.SubItems.Add(rect.ToString());

			// set attributes
			for (int i=0; i < attribCount; i++)
			{
				listViewAttrib.BeginUpdate();
				Amyuni.PDFCreator.IacAttribute attrib = acObject.AttributeByIndex(i);
				object attribValue = null;
				try
				{
					attribValue = attrib.Value;
				}
				catch (System.Exception )
			    {
					 continue;
				}

				if (attribValue != null)
				{
					ListViewItem item = listViewAttrib.Items.Add(acObject.AttributeByIndex(i).Name);
					item.SubItems.Add(attribValue.ToString());
					item.SubItems.Add(attrib.Type.ToString());
					item.SubItems.Add(attrib.HelpString);
					item.SubItems.Add(attrib.Values);
				}
				listViewAttrib.EndUpdate();		
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.listViewAttrib = new System.Windows.Forms.ListView();
			this.columnHeaderName = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderValue = new System.Windows.Forms.ColumnHeader();
			this.lblAttrib = new System.Windows.Forms.Label();
			this.button1 = new System.Windows.Forms.Button();
			this.columnHeaderType = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderValues = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderHelp = new System.Windows.Forms.ColumnHeader();
			this.label1 = new System.Windows.Forms.Label();
			this.listViewProperties = new System.Windows.Forms.ListView();
			this.columnHeaderModified = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderSelected = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderAnnotation = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderPage = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderCoordinates = new System.Windows.Forms.ColumnHeader();
			this.label2 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// listViewAttrib
			// 
			this.listViewAttrib.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							 this.columnHeaderName,
																							 this.columnHeaderValue,
																							 this.columnHeaderType,
																							 this.columnHeaderHelp,
																							 this.columnHeaderValues});
			this.listViewAttrib.FullRowSelect = true;
			this.listViewAttrib.GridLines = true;
			this.listViewAttrib.Location = new System.Drawing.Point(32, 192);
			this.listViewAttrib.MultiSelect = false;
			this.listViewAttrib.Name = "listViewAttrib";
			this.listViewAttrib.Size = new System.Drawing.Size(656, 320);
			this.listViewAttrib.Sorting = System.Windows.Forms.SortOrder.Ascending;
			this.listViewAttrib.TabIndex = 1;
			this.listViewAttrib.View = System.Windows.Forms.View.Details;
			// 
			// columnHeaderName
			// 
			this.columnHeaderName.Text = "Name";
			this.columnHeaderName.Width = 116;
			// 
			// columnHeaderValue
			// 
			this.columnHeaderValue.Text = "Value";
			this.columnHeaderValue.Width = 109;
			// 
			// lblAttrib
			// 
			this.lblAttrib.Location = new System.Drawing.Point(32, 24);
			this.lblAttrib.Name = "lblAttrib";
			this.lblAttrib.Size = new System.Drawing.Size(392, 24);
			this.lblAttrib.TabIndex = 2;
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(313, 536);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(88, 24);
			this.button1.TabIndex = 3;
			this.button1.Text = "Ok";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// columnHeaderType
			// 
			this.columnHeaderType.Text = "Type";
			this.columnHeaderType.Width = 119;
			// 
			// columnHeaderValues
			// 
			this.columnHeaderValues.Text = "Values";
			this.columnHeaderValues.Width = 183;
			// 
			// columnHeaderHelp
			// 
			this.columnHeaderHelp.Text = "Help String";
			this.columnHeaderHelp.Width = 126;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(32, 168);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(136, 16);
			this.label1.TabIndex = 4;
			this.label1.Text = "Attributes";
			// 
			// listViewProperties
			// 
			this.listViewProperties.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								 this.columnHeaderModified,
																								 this.columnHeaderSelected,
																								 this.columnHeaderAnnotation,
																								 this.columnHeaderPage,
																								 this.columnHeaderCoordinates});
			this.listViewProperties.GridLines = true;
			this.listViewProperties.Location = new System.Drawing.Point(32, 88);
			this.listViewProperties.Name = "listViewProperties";
			this.listViewProperties.Size = new System.Drawing.Size(656, 56);
			this.listViewProperties.TabIndex = 5;
			this.listViewProperties.View = System.Windows.Forms.View.Details;
			// 
			// columnHeaderModified
			// 
			this.columnHeaderModified.Text = "Modified";
			this.columnHeaderModified.Width = 118;
			// 
			// columnHeaderSelected
			// 
			this.columnHeaderSelected.Text = "Selected";
			this.columnHeaderSelected.Width = 104;
			// 
			// columnHeaderAnnotation
			// 
			this.columnHeaderAnnotation.Text = "Annotation";
			this.columnHeaderAnnotation.Width = 118;
			// 
			// columnHeaderPage
			// 
			this.columnHeaderPage.Text = "Page Number";
			this.columnHeaderPage.Width = 128;
			// 
			// columnHeaderCoordinates
			// 
			this.columnHeaderCoordinates.Text = "Coordinates";
			this.columnHeaderCoordinates.Width = 215;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(32, 64);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(160, 16);
			this.label2.TabIndex = 6;
			this.label2.Text = "Properties";
			// 
			// AttributesForm
			// 
			this.AcceptButton = this.button1;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(714, 576);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.listViewProperties);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.lblAttrib);
			this.Controls.Add(this.listViewAttrib);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "AttributesForm";
			this.Text = "Object Properties and Attributes";
			this.ResumeLayout(false);

		}
		#endregion

		private void button1_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}
	}
}
